/**
* \file: ServerMonitor.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "ServerMonitor.h"

#include <adit_logging.h>
/* AOAP library header files */
#include <aoap_types.h>
#include <aoap.h>
#include "Server.h"
#include "BdclSmoketest.h"


LOG_IMPORT_CONTEXT(tbdcl)

namespace adit { namespace bdcl {

using namespace uspi;

bool ServerMonitor::start(uint32_t inEventMask)
{
    return startDeviceMonitor(inEventMask);
}

void ServerMonitor::stop()
{
    stopDeviceMonitor();
 }

void ServerMonitor::onDeviceFound(std::shared_ptr<DiscoveredDevice> inDevice)
{
    uint32_t eventMask = 0;
    std::shared_ptr<DiscoveredDeviceUsb> pUsbDevice = std::dynamic_pointer_cast<DiscoveredDeviceUsb>(inDevice);
    /* get event mask from discovered device object */
    eventMask = pUsbDevice->getEventMask();
    if (eventMask == DD_USB_APPLE) {
        std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::FOUND_APPLE_DEVICE, "" ,""));
        Server::instance().queueEvent(event);
        LOG_INFO((tbdcl, "ServerMonitor::%s() onAppleDeviceFound ", __func__));
    } else if (eventMask == DD_USB_AOAP) {
        std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::FOUND_AOAP_DEVICE, "" ,""));
        Server::instance().queueEvent(event);
        LOG_INFO((tbdcl, "ServerMonitor::%s() onAoapDeviceFound ", __func__));
    } else {
        LOG_INFO((tbdcl, "ServerMonitor::%s()  device not does not support AOAP or is not an Apple device", __func__));
        AutoSmoketest::instance().setTestError(NODEVICE);
    }
}

void ServerMonitor::onDeviceLost(std::shared_ptr<DiscoveredDevice> inDevice)
{
    uint32_t eventMask = 0;
    std::shared_ptr<DiscoveredDeviceUsb> pUsbDevice = std::dynamic_pointer_cast<DiscoveredDeviceUsb>(inDevice);
    /* get event mask from discovered device object */
    eventMask = pUsbDevice->getEventMask();

    if (eventMask == DD_USB_APPLE) {
        std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::LOST_APPLE_DEVICE, "" ,""));
        Server::instance().queueEvent(event);
        LOG_INFO((tbdcl, "ServerMonitor::%s() onAppleDeviceLost ", __func__));
    } else if (eventMask == DD_USB_AOAP) {
        std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::LOST_AOAP_DEVICE, "" ,""));
        Server::instance().queueEvent(event);
        LOG_INFO((tbdcl, "ServerMonitor::%s() onAoapDeviceLost ", __func__));
    } else {
        LOG_INFO((tbdcl, "ServerMonitor::%s()  device not does not support AOAP or is not an Apple device", __func__));
    }
}

void ServerMonitor::onDeviceChanged(std::shared_ptr<DiscoveredDevice> inDevice)
{
    std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::CHANGED,"",""));
    /* queue item which played out by workqueue thread */
    Server::instance().queueEvent(event);
}

void ServerMonitor::onDeviceSwitched(std::shared_ptr<DiscoveredDevice> inDevice)
{
    std::shared_ptr<EventItem> event(new EventItem(inDevice, EventType::SWITCHED,"",""));
    /* queue item which played out by workqueue thread */
    Server::instance().queueEvent(event);
}

} } // namespace adit { namespace bdcl {
